<?php
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class Aislin_Classroom_VC_Addon_Google_Course_Carousel {

	protected $namespace = 'scp_google_course_carousel';

	function __construct() {
		add_action( vc_is_inline() ? 'init' : 'admin_init', array( $this, 'integrateWithVC' ) );
		add_action( 'wp', array( $this, 'check_shortcodes' ) );

		add_shortcode( $this->namespace, array( $this, 'render' ) );
	}

	public function check_shortcodes() {

		if ( ! is_admin() ) {
			global $post;

			if ( $post && strpos( $post->post_content, $this->namespace ) ) {
				add_action( 'wp_enqueue_scripts', array( $this, 'loadCssAndJs' ) );
			}
		}
	}

	public function integrateWithVC() {
		if ( ! defined( 'WPB_VC_VERSION' ) ) {
			return;
		}

		$thumbs_dimensions_array = array_merge( array( 'thumbnail'), agc_classroom_get_thumbnail_sizes_vc() , array( 'full-width' ) );

		$args = array(
			'taxonomy' => Aislin_Classroom_Post_Type::TAXONOMY_CATEGORY,
		);

		$project_categories = get_categories( $args );

		$project_category_arr                    = array();
		$project_category_arr['Select Category'] = '';
		foreach ( $project_categories as $project_category ) {
			if ( is_object( $project_category ) && $project_category->term_id ) {
				$project_category_arr[ $project_category->name ] = $project_category->term_id;
			}
		}

		vc_map( array(
			'name'        => esc_html__( 'Class Carousel', 'aislin-classroom' ),
			'description' => esc_html__( 'Display classes', 'aislin-classroom' ),
			'base'        => $this->namespace,
			'class'       => '',
			'controls'    => 'full',
			'icon'        => plugins_url( 'assets/aislin-vc-icon.png', __FILE__ ),
			'category'    => 'Aislin',
			'params'      => array(
				array(
					'type'        => 'textfield',
					'holder'      => 'div',
					'class'       => '',
					'heading'     => esc_html__( 'Title', 'aislin-classroom' ),
					'param_name'  => 'title',
					'value'       => '',
					'description' => esc_html__( 'Title to display on front.', 'aislin-classroom' )
				),
				array(
					'type'        => 'dropdown',
					'holder'      => '',
					'class'       => '',
					'admin_label' => true,
					'heading'     => esc_html__( 'Category', 'aislin-classroom' ),
					'param_name'  => 'category_id',
					'value'       => $project_category_arr,
					'description' => esc_html__( 'If category is selected Course Type will be disregarded.', 'aislin-classroom' ),
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Course Type', 'aislin-classroom' ),
					'param_name' => 'course_type',
					'value'      => array(
						'All'              => 'usercourses',
						'Featured Courses' => 'featuredcourses',
					),
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Image Size', 'aislin-classroom' ),
					'param_name' => 'image_size',
					'value'      => $thumbs_dimensions_array,
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Show Ratings?', 'aislin-classroom' ),
					'param_name' => 'show_ratings',
					'value'      => array(
						'Yes' => '1',
						'No'  => '0',
					),
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Show Category?', 'aislin-classroom' ),
					'param_name' => 'show_category',
					'value'      => array(
						'Yes' => '1',
						'No'  => '0',
					),
				),
				array(
					'type'        => 'dropdown',
					'holder'      => '',
					'class'       => '',
					'heading'     => esc_html__( 'Image takes the full width', 'aislin-classroom' ),
					'description' => esc_html__( 'Inner padding won\'t affect the image', 'aislin-classroom' ),
					'param_name'  => 'image_is_full_width',
					'value'       => array(
						'Yes' => '1',
						'No'  => '0',
					),
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Image is rounded?', 'aislin-classroom' ),
					'param_name' => 'image_is_rounded',
					'value'      => array(
						'No'  => '0',
						'Yes' => '1',
					),
				),
				array(
					'type'       => 'dropdown',
					'class'      => '',
					'heading'    => esc_html__( 'Show Teacher?', 'aislin-classroom' ),
					'param_name' => 'show_teacher',
					'value'      => array(
						'Yes' => '1',
						'No'  => '0',
					),
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Show Excerpt?', 'aislin-classroom' ),
					'param_name' => 'show_excerpt',
					'value'      => array(
						'Yes' => '1',
						'No'  => '0',
					),
				),
				array(
					'type'        => 'textfield',
					'holder'      => '',
					'class'       => '',
					'heading'     => esc_html__( 'Number of Words', 'aislin-classroom' ),
					'param_name'  => 'number_of_words',
					'value'       => '10',
					'description' => esc_html__( 'Number of words of the excerpt.', 'aislin-classroom' ),
					'group'       => '',
				),
				array(
					'type'        => 'textfield',
					'holder'      => '',
					'class'       => '',
					'heading'     => esc_html__( 'Number of Items', 'aislin-classroom' ),
					'param_name'  => 'number_of_items',
					'value'       => '8',
					'description' => esc_html__( 'Number of items to show.', 'aislin-classroom' ),
					'group'       => 'Slider Settings',
				),
				array(
					'type'        => 'textfield',
					'holder'      => '',
					'class'       => '',
					'heading'     => esc_html__( 'Number of Items per Slide', 'aislin-classroom' ),
					'param_name'  => 'number_of_items_per_slide',
					'value'       => '4',
					'description' => esc_html__( 'Number of items per slide.', 'aislin-classroom' ),
					'group'       => 'Slider Settings',
				),
				array(
					'type'       => 'textfield',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Slide Speed', 'aislin-classroom' ),
					'param_name' => 'slide_speed',
					'value'      => '500',
					'group'      => 'Slider Settings',
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Auto Play', 'aislin-classroom' ),
					'param_name' => 'autoplay',
					'value'      => array(
						'No'  => '0',
						'Yes' => '1',
					),
					'group'      => 'Slider Settings',
				),
				array(
					'type'       => 'dropdown',
					'holder'     => '',
					'class'      => '',
					'heading'    => esc_html__( 'Show Bullets', 'aislin-classroom' ),
					'param_name' => 'show_bullets',
					'value'      => array(
						'No'  => '0',
						'Yes' => '1',
					),
					'group'      => 'Slider Settings',
				),
				array(
					'type'        => 'dropdown',
					'holder'      => '',
					'class'       => '',
					'heading'     => esc_html__( 'Adaptive Height', 'aislin-classroom' ),
					'param_name'  => 'adaptive_height',
					'description' => 'Use it only for one item per page setting.',
					'value'       => array(
						'No'  => '0',
						'Yes' => '1',
					),
					'group'       => 'Slider Settings',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Extra class name', 'aislin-classroom' ),
					'param_name'  => 'el_class',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'aislin-classroom' ),
				),
			)
		) );
	}

	public function render( $atts, $content = null ) {

		extract( shortcode_atts( array(
			'title'                     => '',
			'category_id'               => null,
			'course_type'               => 'usercourses',
			'includes'                  => '',
			'number_of_items'           => '8',
			'number_of_items_per_slide' => '4',
			'slide_speed'               => '500',
			'autoplay'                  => '0',
			'show_bullets'              => '0',
			'show_ratings'              => '1',
			'show_category'             => '1',
			'image_is_full_width'       => '1',
			'image_is_rounded'          => '0',
			'show_excerpt'              => '1',
			'show_teacher'              => '1',
			'number_of_words'           => '10',
			'adaptive_height'           => 'true',
			'image_size'                => 'thumbnail',
			'el_class'                  => '',
		), $atts ) );

			ob_start();
			// adapted from woothemes-sensei/inc/woothemes-sensei-template.php shortcode_featured_courses()
			global $post, $wp_query, $current_user;
			$query_type = $course_type;
			$amount = $number_of_items;
			$taxonomy_name = Aislin_Classroom_Post_Type::TAXONOMY_CATEGORY;

			$args = array(
				'numberposts'      => - 1,
				'post_type'        => Aislin_Classroom_Post_Type::POST_TYPE,
				'post_status'      => 'publish',
				'suppress_filters' => 0
			);

			if ( $category_id ) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => $taxonomy_name,
						'field'    => 'term_id',
						'terms'    => $category_id
					)
				);
			} 

			if ($course_type == 'featuredcourses') {
				$args['meta_key']   = Aislin_Classroom_Post_Type::META_IS_FEATURED;
				$args['meta_query'] = array(
					array(
						'key'     => Aislin_Classroom_Post_Type::META_IS_FEATURED,
						'value'   => '1',
						'compare' => '=',
					),
				);
			}
			$posts_array = get_posts( $args );
			$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'aislin-featured-classes-carousel ' . $el_class, $this->namespace, $atts );
			?>
			<?php if ( count( $posts_array ) > 0 ): ?>
				<?php if ( $title ): ?>
					<h2><?php echo esc_html( $title ); ?></h2>
				<?php endif ?>
				<div class="<?php echo esc_attr( $css_class ); ?>"
					data-items="<?php echo esc_attr( (int) $number_of_items_per_slide ); ?>"
					data-slide-speed="<?php echo esc_attr( (int) $slide_speed ); ?>"
					data-auto-play="<?php echo esc_attr( (int) $autoplay ? 'true' : 'false' ); ?>"
					data-show-bullets="<?php echo esc_attr( (int) $show_bullets ? 'true' : 'false' ); ?>"
					data-auto-height="<?php echo esc_attr( (int) $adaptive_height ? 'true' : 'false' ); ?>"
				>
				<?php foreach ( $posts_array as $post_item ): ?>
					
					<?php
						$post_id               = absint( $post_item->ID );
						$course                = agc_get_course($post_id, false);

						// Get meta data
						$post_title            = $post_item->post_title;
						$section_name          = $course->get_section();
						$user_info             = get_userdata( absint( $post_item->post_author ) );
						$author_link           = get_author_posts_url( absint( $post_item->post_author ) );
						$author_display_name   = $user_info->display_name;
						$author_id             = $post_item->post_author;
						$category_output       = get_the_term_list( $post_id, $taxonomy_name, '', ', ', '' );
						$lesson_count          = 11;
						$is_user_taking_course = false;
					?>
						<div>
							<?php if ( $image_is_full_width ): ?>
								<?php include 'partials/image.php'; ?>
							<?php endif ?>
							<div class="item-inner-wrap">
								<?php
								if ( ! $image_is_full_width ) {
									include 'partials/image.php';
								}
								include 'partials/title.php';
								include 'partials/button.php';
								?>
							</div>
						</div>
					<?php endforeach ?>
				</div>
			<?php endif ?>
			<?php
			return ob_get_clean();
	}

	public function loadCssAndJs() {
		wp_enqueue_style( 'owlcarousel', plugins_url( 'assets/owl.carousel.css', __FILE__ ) );
		wp_enqueue_style( 'owl-theme', plugins_url( 'assets/owl.theme.css', __FILE__ ) );
		wp_enqueue_style( 'owl-transitions', plugins_url( 'assets/owl.transitions.css', __FILE__ ) );
		wp_enqueue_style( 'google-course-carousel', plugins_url( 'assets/course-carousel.css', __FILE__ ) );

		wp_enqueue_script( 'owl-carousel', plugins_url( 'assets/owl.carousel.min.js', __FILE__ ), array( 'jquery' ), false, true );
		wp_enqueue_script( 'google-course-carousel', plugins_url( 'assets/course-carousel.js', __FILE__ ), array( 'jquery' ), false, true );
	}

}

new Aislin_Classroom_VC_Addon_Google_Course_Carousel();
