<?php
/*
 
 Template Name: Team 4 Cols v2
 
 */

get_header(); ?>

<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' ); ?>

<?php $mt_page_title =  get_post_meta($post->ID, "mt_page_title", true); ?>

<section class="topSingleBkg topPageBkg <?php if(!empty($image)):?> topSingleBkgImg <?php endif;?>">  

<?php if(!empty($image)):?>

<div class="item-img" style="background-image:url('<?php echo esc_url($image[0]); ?>');"></div>

<?php endif;?>

  <div class="inner-desc">	 
  
 <h1 class="post-title single-post-title"><?php if(!empty($mt_page_title)): echo esc_html($mt_page_title); else: the_title(); endif;?></h1>
 
</div>

</section>

<section id="wrap-content" class="page-content">

<div class="container">
<div class="row">
<div class="col-md-12">

<?php if($post->post_content!="") : ?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div id="post-<?php the_ID(); ?>" class="page-holder custom-page-template page-full">

<?php the_content(); ?>

</div>
<?php  endwhile;

else: ?>

<p class="alignc"><?php esc_html_e( 'Sorry, but it seems we can&rsquo;t find what you&rsquo;re looking for. Try the menu above.', 'liberis' ); ?></p>

<?php endif; endif; ?>

<div class="team-holder v2 clearfix">

   <?php	global $wp_query;
   
   $paged = get_query_var('paged') ? get_query_var('paged') : 1;
		
	$defaults = array('post_type' => 'mt_team', 'posts_per_page' => 12, 'paged'=> $paged);
	$wp_query = new WP_Query($defaults);
		
	?>
              
	<?php while (have_posts() ) : the_post(); 
	
	 $mt_team_position =  get_post_meta($post->ID, "mt_team_position", true); 
	 $mt_team_phone =  get_post_meta($post->ID, "mt_team_phone", true);
	 $mt_team_mail =  get_post_meta($post->ID, "mt_team_mail", true);
	 $mt_team_twitter_url =  get_post_meta($post->ID, "mt_team_twitter_url", true);
	 $mt_team_facebook_url =  get_post_meta($post->ID, "mt_team_facebook_url", true);
	 $mt_team_gplus_url =  get_post_meta($post->ID, "mt_team_gplus_url", true);
	 $mt_team_linkedin_url =  get_post_meta($post->ID, "mt_team_linkedin_url", true);
	 ?>
	 
 <div class="team-post team-postv2 team-4colv2">
 
 <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'liberis-image600x500' ); ?>

<a href="<?php the_permalink(); ?>">
<div class="team-imgv2" style="background-image:url('<?php if(!empty($image)) echo esc_url($image[0]); ?>');"></div>
</a>

<div class="team-content v2">

<div class="team-position"> <?php echo esc_html($mt_team_position); ?> </div>
<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

<ul class="team-contact">
	 
	 <?php if (!empty($mt_team_phone) ): ?>
     <li><i class="fa fa-phone"></i> <?php echo esc_html($mt_team_phone);?></li>
     <?php endif; ?>

	 
	 </ul>

</div>

<ul class="social-media">
     
     <?php if (!empty($mt_team_twitter_url) ): ?>
     <li><a class="social-twitter" href="<?php echo esc_url($mt_team_twitter_url);?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
     <?php endif; ?>
	 
	 <?php if (!empty($mt_team_facebook_url) ): ?>
     <li><a class="social-facebook" href="<?php echo esc_url($mt_team_facebook_url);?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
     <?php endif; ?>
	 
	 <?php if (!empty($mt_team_gplus_url) ): ?>
     <li><a class="social-gplus" href="<?php echo esc_url($mt_team_gplus_url);?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
     <?php endif; ?>
	 
	  <?php if (!empty($mt_team_linkedin_url) ): ?>
     <li><a class="social-linkedin" href="<?php echo esc_url($mt_team_linkedin_url);?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
     <?php endif; ?>

      </ul>



</div><!-- /team-post -->
    
 <?php endwhile; wp_reset_postdata();  ?>
 
 <?php if(function_exists('liberis_pagenavi') ) : ?>

	<?php liberis_pagenavi();  ?>
        
	<?php else : ?>

  <ul class="other-entries">
			<li class="newer-entries"><span><?php previous_posts_link(esc_html__('Previous', 'liberis')); ?></span></li>
            <li class="older-entries"><span><?php next_posts_link(esc_html__('Next', 'liberis')); ?></span></li>
          </ul>
      
<?php endif; ?>

</div>

</div><!--col-md-12-->
</div><!--row-->
</div><!--container-->
</section>

<?php get_footer(); ?>