<?php 

function liberis_customizer_css() {

	$custom_css = '';
	$body_styles = '';
	
	// start body

	$mt_body_font = get_theme_mod( 'mt_body_font', 'Lato');
	$mt_body_font_size = get_theme_mod( 'mt_body_font_size');
	$mt_body_text_color = get_theme_mod( 'mt_body_text_color');
	
	$body_styles .= 'font-family: ' . $mt_body_font . ';';
	
	if( !empty($mt_body_font_size) ) { $body_styles .= 'font-size: ' . $mt_body_font_size . 'px;'; }
	if( !empty($mt_body_text_color) ) { $body_styles .= 'color: ' . $mt_body_text_color . ';';
	
	 }
		
	$body_styles = 'body{' .$body_styles. '}';
	
	$custom_css .= $body_styles;
	$custom_css .= '.widgettitle, .testimonial-info h5, .testimonial-info span, #respond h3 { font-family:'.$mt_body_font.', sans-serif; }';
	
	// post titles
	
	$mt_titles_font = get_theme_mod( 'mt_titles_font', 'Playfair Display');
	$custom_css .= 'h1, h2, h3, h4, h5, h6, blockquote, .logo-txt, .comment-author span, .slider-caption, .testimonial-info, .nav-post a{ font-family:'.$mt_titles_font.', serif; }';
	
	// link color
	
	$mt_link_color = get_theme_mod( 'mt_link_color');
	
	if (!empty($mt_link_color)){ $custom_css .= 'a:hover, p a:hover, .practice-icon-subtitle, .icon-top, .article-title a:hover, .tagcloud a, .tags-single-page a, .view-more:hover, #submit:hover, .faq-title.active, .faq-title:hover, .faq-title.active:before, .faq-title.active a, .faq-title:hover a, .faq-title:hover:before, .view-more, #submit, .wpcf7-submit, .pcolor, .wp-block-coblocks-pricing-table-item .wp-block-coblocks-pricing-table-item__features li:before, .wp-block-social-links:not(.is-style-logos-only) .social-mt, .related-title a:hover{color:'.$mt_link_color.';}';
		$custom_css .= '.small-intro:after, .stats [class^="col-md-"]:after, .gallery-item:hover .gallery-item-img:before, .team-img:after, .team-imgv2:after, .team-text:before, .tagcloud a:hover, .tags-single-page a:hover, .post-meta li.meta-sticky, .view-more:hover, #submit:hover, .wpcf7-submit:hover, .icon-top-v2 { background: '.$mt_link_color.';}';
		$custom_css .= '.stats, .practice-icon-holder:hover .practice-icon-border, .tagcloud a, .tags-single-page a, .menu-nav li a:before, .view-more, #submit, .wpcf7-submit, .feature-cols{ border-color:'.$mt_link_color.'; }';
		$custom_css .= '.home-title span{box-shadow:inset 0 -0.20em '.$mt_link_color.';}';
		$custom_css .= '#respond h3 span, .widgettitle span{box-shadow:inset 0 -0.25em '.$mt_link_color.';}';
		
	}
	
	// heavy color
	$mt_heavy_color = get_theme_mod( 'mt_heavy_color');
	
	if (!empty($mt_heavy_color)){
	
	$custom_css .= 'h1, h2, h3, h4, h5, h6, blockquote, a, .article-title a, .author-single-page h4 a, .comment-author span, .comment-author .author a, .comment-reply-link, .widgettitle, .page-numbers, .nav-page a, .page-links a, .post-password-form input[type="submit"], .faq-title a, .post-meta li.meta-sticky{color:'.$mt_heavy_color.';}';
	
	$custom_css .= 'p a, .page-links a:hover, .post-password-form input[type="submit"]:hover {border-color:'.$mt_heavy_color.';}';
	$custom_css .= '.page-links a:hover, .post-password-form input[type="submit"]:hover, .scrollup i, .testimonial-info h5:before{background:'.$mt_heavy_color.';}';
	
	}
	
	// headings size
	$mt_h1_size = get_theme_mod( 'mt_h1_size');
	if (!empty($mt_h1_size)){ $custom_css .= 'h1{font-size:'.$mt_h1_size.'px;}'; }
	
	$mt_h2_size = get_theme_mod( 'mt_h2_size');
	if (!empty($mt_h2_size)){ $custom_css .= 'h2{font-size:'.$mt_h2_size.'px;}'; }
	
	$mt_h3_size = get_theme_mod( 'mt_h3_size');
	if (!empty($mt_h3_size)){ $custom_css .= 'h3{font-size:'.$mt_h3_size.'px;}'; }
	
	$mt_h4_size = get_theme_mod( 'mt_h4_size');
	if (!empty($mt_h4_size)){ $custom_css .= 'h4{font-size:'.$mt_h4_size.'px;}'; }
	
	$mt_h5_size = get_theme_mod( 'mt_h5_size');
	if (!empty($mt_h5_size)){ $custom_css .= 'h5{font-size:'.$mt_h5_size.'px;}'; }
	
	$mt_h6_size = get_theme_mod( 'mt_h6_size');
	if (!empty($mt_h6_size)){ $custom_css .= 'h6{font-size:'.$mt_h6_size.'px;}'; }
	
	// menu colors
	
	$mt_menu_normal_color = get_theme_mod( 'mt_menu_normal_color');
	if (!empty($mt_menu_normal_color)){

	$custom_css .= '.menu-nav li a, .menu-mobile li a{color:'.$mt_menu_normal_color.';}';
	
	}
	
	$mt_menu_hover_color = get_theme_mod( 'mt_menu_hover_color');
	if (!empty($mt_menu_hover_color)){
		
	$custom_css .= '.menu-nav li a:hover, .menu-mobile li:hover > a, .menu-mobile li.current-menu-item > a{color:'.$mt_menu_hover_color.';}';	
	
	}
	
	$mt_submenu_bkg_color = get_theme_mod( 'mt_submenu_bkg_color');
	 if (!empty($mt_submenu_bkg_color)){

	$custom_css .= '.menu-nav ul {background:'.$mt_submenu_bkg_color.';}';
	
	$custom_css .= '.menu-nav ul:before {border-color: transparent transparent '.$mt_submenu_bkg_color.' transparent;}';
	 
	 }
	 
	 $mt_submenu_normal_color = get_theme_mod( 'mt_submenu_normal_color');
	 if (!empty($mt_submenu_normal_color)){

	$custom_css .= '.menu-nav ul li > a{color:'.$mt_submenu_normal_color.';}';
	
	 }
	 
	  $mt_submenu_hover_color = get_theme_mod( 'mt_submenu_hover_color');
	 if (!empty($mt_submenu_hover_color)){  
	 
	 $custom_css .= '.menu-nav ul li a:hover, .menu-nav li:hover ul li a:hover{color:'.$mt_submenu_hover_color.';}';
	 
	 }
	 
	// footer colors
	$mt_footer_bkg_color = get_theme_mod( 'mt_footer_bkg_color');
	if (!empty($mt_footer_bkg_color)){ $custom_css .= 'footer{background:'.$mt_footer_bkg_color.';}'; }
	
	$mt_footer_txt_color = get_theme_mod( 'mt_footer_txt_color');
	if (!empty($mt_footer_txt_color)){ $custom_css .= 'footer{color:'.$mt_footer_txt_color.';}'; }
	
	$custom_css .= '.w-btn a:hover {color: #252525; background: #ffffff; }';	
	 
	 if ( is_admin_bar_showing() ) { $custom_css .= '#header-3.nav-fixed-top, .nav-holder-1.nav-fixed-top, .header-2.nav-fixed-top{margin-top:42px;} @media (max-width: 767px) {.mobile-top{margin-top:42px;} .mobile-menu-holder.is-active{top:10%;} }'; }
	
	wp_add_inline_style( 'liberis-style-css', $custom_css );
	
}
	
add_action( 'wp_enqueue_scripts', 'liberis_customizer_css', 99);
?>